define([
		'app',
		'NotificationsService',
		'NotificationsConstants',
		'NotificationsSummaryController',
		'NotificationsDetailsController',
		'NotificationSettingsController',
		'NotificationSettingsService',
		'NotificationsPreferencesService'
	],
	function (app) {
		'use strict';

		app.config(function ($stateProvider) {
			$stateProvider
				.state('main.auth.two-panel.secondary-navigation.notifications', {
					url: '/notifications',
					appNavIndex: 3,
					data: {
						moduleName: 'Notifications',
						panel: 'secondary',
						baseStateName : 'main.auth.two-panel.secondary-navigation.notifications',
						initialState : 'summary',
						paramSections : [
							{
								paramValue : 'all-notifications',
								sectionName : 'All Notifications',
								sectionIndex : 1
							},
							{
								paramValue : 'fit-heart-notices',
								sectionName : 'VA FitHeart App Notices',
								sectionIndex : 2
							},
							{
								paramValue : 'va-health-messages',
								sectionName : 'VA Health Messages',
								sectionIndex : 3
							}
						],
						headerButton: {
							iconClass: 'icon icon-settings',
							buttonClass: '',
							text: 'Notification Settings',
							service: 'NotificationSettingsService'
						}
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/notifications/pages/notifications-placeholder_template.html'
						}
					}
				})
				.state('main.auth.two-panel.secondary-navigation.notifications.summary', {
					url: '/{section:all-notifications|fit-heart-notices|va-health-messages}/summary',
					data: {
						panel : 'primary',
						backState : '^'
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/notifications/pages/summary/notifications-summary_template.html',
							controller: 'NotificationsSummaryController'
						}
					}
				})
				.state('main.auth.two-panel.secondary-navigation.notifications.detail', {
					url: '/{section:all-notifications|fit-heart-notices|va-health-messages}/detail?id',
					data : {
						panel : 'primary',
						backState : '^.summary'
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/notifications/pages/detail/notifications-details_template.html',
							controller: 'NotificationsDetailsController'
						}
					}
				});
		});
	}
);
